/*---------------------------------------------------------------*/

#include "typesiigs.r"

/*------------------- Values used through out -------------------*/

#define MainWindow $1000




/*----------------------- About Box ------------------------------*/
resource rAlertString (1) {
 "0\$19\$00\$A0\$00\$AA\$00\$E0\$01"
 "0/"
 TBCenterJust
 TBStyleOutline
 "Teach"
 TBEndOfLine
 TBStylePlain
 "A sample program to demonstrate editing text files.  Almost all the work is "
 "done by TextEdit and TaskMaster."
 TBEndOfLine
 TBEndOfLine
 "by"
 TBEndOfLine
 "Steven E. Glass"
 TBEndOfLine
 TBEndOfLine
 "Copyright Apple Computer, Inc."
 TBEndOfLine
 "All Rights Reserved"
 TBEndOfLine
 "Version 3.0/^#6\$00"
};






/*----------------------Startup Record ---------------------------*/
resource rToolStartup (1) {
 mode640, /* master SCB */
 {
        3,$0300,  /* misc tools */
        4,$0301,  /* quickdraw */
        5,$0302,  /* desk manager */
        6,$0300,  /* eventMgr */
/*      7,$0200,  /* scheduler */
/*      8,$0301,  /* sound tools */
/*      9,$0201,  /* ADB tools */
/*      10,$0202, /* SANE */
        11,$0200, /* int math */
        14,$0301, /* Window Manager */
        15,$0301, /* Menu Manager */
        16,$0301, /* Control Manager */
        18,$0301, /* QD Aux */
        19,$0300, /* print manager */
        20,$0301, /* LineEdit tool set */
        21,$0302, /* Dialog Manager */
        22,$0300, /* Scrap manager */
        23,$0301, /* standard file */
/*      25,$0104, /* NoteSynth */
/*      26,$0104, /* Note Seq */
        27,$0301, /* Font manager */
        28,$0301, /* list manager */
/*      29,$0101, /* ACE */
/*      32,$0103, /* Midi Tools */
        34,$0101  /* text edit */
 }
};




/*---------------------------------------------------------------------------*/
/*
/* Main Window
/*
/* This is the template for the main window that will contain any text that
/* is typed or loaded.
/*
/*---------------------------------------------------------------------------*/
resource rWindParam1 (MainWindow) {
 fTitle+fMove+fZoom+fClose, /* Frame Bits */
 0x201, /* title ID */
 0, /* ref Con */
 {0,0,0,0}, /* Zoom Rect */
 0, /* color table id */
 {0,0}, /* origin */
 {0,0}, /* data size */
 {0,0}, /* max height-width */
 {0,0}, /* scroll amount, hor,ver */
 {0,0}, /* page amount */
 0, /* wInfo Ref Con */
 0, /* wInfo height */
 {40,20,180,550}, /* window Position */
 infront, /* wPlane */
 MainWindow, /* Control Ref */
 ResourceToResource /* Verb */
};


resource rControlList (MainWindow) {
 {
 MainWindow
 };
};


resource rControlTemplate (MainWindow) {
 MainWindow, /* control ID */
 {0,0,0,0}, /* control rectangle */
 EditTextControl{{ /* control type */
 0x0000, /* flag */
 fCtlCanBeTarget+fCtlWantsEvents+fctlProcNotPtr+fctlTellAboutSize, /* more flags */
 0, /* ref con */
 0, /* text flags */
 {0xFFFF,0xFFFF,0xFFFF,0xFFFF}, /* indent rect */
 0xFFFFFFFF, /* Vert Bar */
 0, /* Vert Amount */
 0, /* hor bar */
 0 /* hor Amount */
 }};
};





/*********************************************************************/
/*
/* Menus
/*
/*********************************************************************/

#define AppleMenuID $1100
#define FileMenuID $1200
#define EditMenuID $1300
#define FontMenuID $1400
#define StyleMenuID $1500
#define SizeMenuID $1600

#Define AboutID $1101

#define CloseID 255
#define QuitID $1202
#define NewID $1203
#define OpenID $1204
#define SaveID $1205
#define SaveAsID $1206
#define PageSetupID $1207
#define PrintID $1208

#define UndoID 250
#define CutID 251
#define CopyID 252
#define PasteID 253
#define ClearID 254
#define SelectAllID $1306

#define ChooseFontID $1401

#define PlainID $1501
#define BoldID $1502
#define ItalicID $1503
#define UnderlineID $1504
#define OutlineID $1505
#define ShadowID $1506

#define Size8ID $1601
#define Size10ID $1602
#define Size12ID $1603
#define Size16ID $1604
#define Size20ID $1605
#define Size24ID $1606



resource rMenuBar (1) {
 {
 AppleMenuID,
 FileMenuID,
 EditMenuID,
 FontMenuID,
 StyleMenuID,
 SizeMenuID
 };
};

resource rMenu (AppleMenuID) {
 AppleMenuID,
 RefIsResource*MenuTitleRefShift+RefIsResource*ItemRefShift+fAllowCache,
 AppleMenuID,
 { AboutID };
};

resource rMenu (FileMenuID) {
 FileMenuID,
 RefIsResource*MenuTitleRefShift+RefIsResource*ItemRefShift+fAllowCache,
 FileMenuID,
 {
 NewID,
 OpenID,
 SaveID,
 SaveAsID,
 CloseID,
 PageSetupID,
 PrintID,
 QuitID 
 };
};

resource rMenu (EditMenuID) {
 EditMenuID,
 RefIsResource*MenuTitleRefShift+RefIsResource*ItemRefShift+rmDisabled+rmAllowCache,
 EditMenuID,
 {
 UndoID,
 CutID,
 CopyID,
 PasteID,
 ClearID,
 SelectAllID
 };
 };
resource rMenu (FontMenuID) {
 FontMenuID,
 RefIsResource*MenuTitleRefShift+RefIsResource*ItemRefShift+rmDisabled+rmAllowCache,
 FontMenuID,
 {
 ChooseFontID
 };
 };

resource rMenu (StyleMenuID) {
 StyleMenuID,
 RefIsResource*MenuTitleRefShift+RefIsResource*ItemRefShift+rmDisabled+rmAllowCache,
 StyleMenuID,
 {
 PlainID,
 BoldID,
 ItalicID,
 UnderLineID,
 ShadowID,
 OutlineID
 };
 };

resource rMenu (SizeMenuID) {
 SizeMenuID,
 RefIsResource*MenuTitleRefShift+RefIsResource*ItemRefShift+rmDisabled+rmAllowCache,
 SizeMenuID,
 {
 Size8ID,
 Size10ID,
 Size12ID,
 Size16ID,
 Size20ID,
 Size24ID
 };
 };

resource rMenuItem (AboutID) {
 AboutID,
 "","",
 0,
 RefIsResource*ItemTitleRefShift+rMIDivider,
 AboutID
};

resource rMenuItem (UndoID) {
 UndoID,
 "","",
 0,
 RefIsResource*ItemTitleRefShift+rMIDivider,
 UndoID
};

resource rMenuItem (CutID) {
 CutID,
 "X","x",
 0,
 RefIsResource*ItemTitleRefShift,
 CutID
};

resource rMenuItem (CopyID) {
 CopyID,
 "C","c",
 0,
 RefIsResource*ItemTitleRefShift,
 CopyID
};

resource rMenuItem (PasteID) {
 PasteID,
 "V","v",
 0,
 RefIsResource*ItemTitleRefShift,
 PasteID
};

resource rMenuItem (ClearID) {
 ClearID,
 "","",
 0,
 RefIsResource*ItemTitleRefShift+rMIDivider,
 ClearID
};

resource rMenuItem (SelectAllID) {
 SelectAllID,
 "A","a",
 0,
 RefIsResource*ItemTitleRefShift,
 SelectAllID
};

resource rMenuItem (NewID) {
 NewID,
 "N","n",
 0,
 RefIsResource*ItemTitleRefShift,
 NewID
};

resource rMenuItem (OpenID) {
 OpenID,
 "O","o",
 0,
 RefIsResource*ItemTitleRefShift,
 OpenID
};

resource rMenuItem (SaveID) {
 SaveID,
 "S","s",
 0,
 RefIsResource*ItemTitleRefShift,
 SaveID
};

resource rMenuItem (SaveAsID) {
 SaveAsID,
 "","",
 0,
 RefIsResource*ItemTitleRefShift,
 SaveAsID
};

resource rMenuItem (CloseID) {
 CloseID,
 "W","w",
 0,
 RefIsResource*ItemTitleRefShift+rMIDivider,
 CloseID
};

resource rMenuItem (PageSetupID) {
 PageSetupID,
 "","",
 0,
 RefIsResource*ItemTitleRefShift,
 PageSetupID
};

resource rMenuItem (PrintID) {
 PrintID,
 "P","p",
 0,
 RefIsResource*ItemTitleRefShift+rMIDivider,
 PrintID
};

resource rMenuItem (QuitID) {
 QuitID,
 "Q","q",
 0,
 RefIsResource*ItemTitleRefShift,
 QuitID
};

resource rMenuItem (ChooseFontID) {
 ChooseFontID,
 "","",
 0,
 RefIsResource*ItemTitleRefShift+rMIDivider,
 ChooseFontID
};



resource rMenuItem (PlainID) {
 PlainID,
 "","",
 0,
 RefIsResource*ItemTitleRefShift,
 PlainID
};

resource rMenuItem (BoldID) {
 BoldID,
 "","",
 0,
 RefIsResource*ItemTitleRefShift+rMIBold,
 BoldID
};

resource rMenuItem (ItalicID) {
 ItalicID,
 "","",
 0,
 RefIsResource*ItemTitleRefShift+rMIItalic,
 ItalicID
};

resource rMenuItem (UnderlineID) {
 UnderlineID,
 "","",
 0,
 RefIsResource*ItemTitleRefShift+rMIUnderline,
 UnderlineID
};

resource rMenuItem (ShadowID) {
 ShadowID,
 "","",
 0,
 RefIsResource*ItemTitleRefShift+rMIShadow,
 ShadowID
};

resource rMenuItem (OutlineID) {
 OutlineID,
 "","",
 0,
 RefIsResource*ItemTitleRefShift+rMIOutline,
 OutlineID
};

resource rMenuItem (Size8ID) {
 Size8ID,
 "","",
 0,
 RefIsResource*ItemTitleRefShift,
 Size8ID
};

resource rMenuItem (Size10ID) {
 Size10ID,
 "","",
 0,
 RefIsResource*ItemTitleRefShift,
 Size10ID
};

resource rMenuItem (Size12ID) {
 Size12ID,
 "","",
 0,
 RefIsResource*ItemTitleRefShift,
 Size12ID
};

resource rMenuItem (Size16ID) {
 Size16ID,
 "","",
 0,
 RefIsResource*ItemTitleRefShift,
 Size16ID
};

resource rMenuItem (Size20ID) {
 Size20ID,
 "","",
 0,
 RefIsResource*ItemTitleRefShift,
 Size20ID
};

resource rMenuItem (Size24ID) {
 Size24ID,
 "","",
 0,
 RefIsResource*ItemTitleRefShift,
 Size24ID
};







resource rPString (AppleMenuID,noCrossBank) {
 "@"
 };
resource rPString (FileMenuID,noCrossBank) {
 " File "
 };
resource rPString (EditMenuID,noCrossBank) {
 " Edit "
 };
resource rPString (FontMenuID,noCrossBank) {
 " Font "
 };
resource rPString (AboutID,noCrossBank) {
 "About Teach..."
 };
resource rPString (CloseID,noCrossBank) {
 "Close"
 };
resource rPString (UndoID,noCrossBank) {
 "Undo"
 };
resource rPString (CutID,noCrossBank) {
 "Cut"
 };
resource rPString (CopyID,noCrossBank) {
 "Copy"
 };
resource rPString (PasteID,noCrossBank) {
 "Paste"
 };
resource rPString (ClearID,noCrossBank) {
 "Clear"
 };
resource rPString (SelectAllID,noCrossBank) {
 "Select All"
 };
resource rPString (QuitID,noCrossBank) {
 "Quit"
 };

resource rPString (NewID,noCrossBank) {
 "New"
 };
resource rPString (OpenID,noCrossBank) {
 "Open"
 };
resource rPString (SaveID,noCrossBank) {
 "Save"
 };
resource rPString (SaveAsID,noCrossBank) {
 "Save as..."
 };
resource rPString (PageSetupID,noCrossBank) {
 "Page Setup..."
 };
resource rPString (PrintID,noCrossBank) {
 "Print..."
 };
resource rPString (ChooseFontID,noCrossBank) {
 "Choose Font..."
 };
resource rPString (PlainID,noCrossBank) {
 "Plain"
 };
resource rPString (BoldID,noCrossBank) {
 "Bold"
 };
resource rPString (ItalicID,noCrossBank) {
 "Italic"
 };
resource rPString (UnderlineID,noCrossBank) {
 "Underline"
 };
resource rPString (ShadowID,noCrossBank) {
 "Shadow"
 };
resource rPString (OutlineID,noCrossBank) {
 "Outline"
 };
resource rPString (Size8ID,noCrossBank) {
 "8"
 };
resource rPString (Size10ID,noCrossBank) {
 "10"
 };
resource rPString (Size12ID,noCrossBank) {
 "12"
 };
resource rPString (Size16ID,noCrossBank) {
 "16"
 };
resource rPString (Size20ID,noCrossBank) {
 "20"
 };
resource rPString (Size24ID,noCrossBank) {
 "24"
 };


resource rPString (StyleMenuID,noCrossBank) {
 " Styles "
 };

resource rPString (SizeMenuID,noCrossBank) {
 " Sizes "
 };
